#--------------------------------------------------------
#	Script PiXYZ STUDIO - Generate Phantom Mesh
#
#	This Python script is meant to be used in PiXYZ STUDIO 
#	Open the script in STUDIO Script window, and click the Execute button (CTRL+E)
#	
#	This script is an APPROXIMATE version in Python of the scenario GENERATE PHANTOM MESH available in the SCENARIOS menu
#	See the API documentation for more information on that specific scenario, and on all the unitary algorithms used below
#	
#	Copyright PiXYZ Software - 2018
#--------------------------------------------------------

DEFEATURING_MAX_DIAMETER=15
TEXTURE_RESOLUTION=1024
TEXTURE_PADDING=1

#Texture maps to bake
BAKE_DIFFUSE=True

#Gets selection
root = scene.getSelectionedOccurrences()
#if empty set as root
if root == []:
    root = [[scene.getRoot()]]

#Repairs CAD models (by opposition to mesh models) if present in the scene (does nothing otherwise)
algo.repairCAD(root, 0.1, False)

#Creates meshes out of CAD models if present in the scene (does nothing otherwise), with automatic UV generation (based on CAD faces) on channel 1
algo.tessellate(root, 0.1, -1, 20, True, algo.UVGenerationMode.UniformUV, 1)

#Repairs meshes
algo.repairMesh(root, 0.1)

#Merges parts located in final assemblies in the Product Structure (tree)
scene.mergeFinalAssemblies()

try:
    #Tries to remove holes (Defeature algo) within the defined diameter 
    algo.defeature(root, True, False, True, DEFEATURING_MAX_DIAMETER)
    #Fails if there is no patches (are used to find holes)
except:
    #Creates patches to identify holes
    algo.identifyPatches(root)
    try:
        #Retries to remove holes
        algo.defeature(root, True, False, True, DEFEATURING_MAX_DIAMETER)
    except:
        #Error
        print("Failed to defeature")

#Deletes patches on the meshes prior to decimate them
algo.deletePatches(root)

#Deletes lines, useless for export
algo.deleteLines(root)

#Decimates meshes
algo.decimate(root, 1, -1, 1)

#Removes hidden polygons
algo.hiddenRemoval(root, algo.SelectionLevel.Polygons, 1024, 16)

#Merges all parts
result = scene.mergeParts(root)


if BAKE_DIFFUSE:
    maps = []
    maps.append(algo.MapType.Diffuse)

    algo.mapUvOnAABB(result, False, 100.000000, 0, True)
    algo.repackUV(result, 0, True, TEXTURE_RESOLUTION, TEXTURE_PADDING * 2, True)
    
    source = []
    images = algo.bakeMaps(result, source, maps, 0, TEXTURE_RESOLUTION, TEXTURE_PADDING)
    if len(images) != len(maps):
        quit()

    diffuseMapIndex = 0

    mat = material.createMaterial("Baked", "PBR")
    core.setProperty(mat, "albedo", "TEXTURE([[1,1],[0,0],"+str(images[diffuseMapIndex])+", 0])")
    
    algo.deletePatches(result, False)
    
    core.setProperty(result[-1][-1], "Material", str(mat))

core.setProperty(result[-1][-1], "Name", "PhantomMesh")